appModule.directive("noticeItemContextMenu",["$translate","utils", function(translate,utils){
    return{
        template: `<div class="noticeItemContext hide" ng-click="hideMe($event);">
                   <div class="btn edit" ng-click="hideMe($event);onEdit({notice:item,$event:$event})" translate="notice.edit" ng-show="!item.id"></div>
                   <div class="btn delete" ng-click="hideMe($event);onDelete({notice:item,$event:$event})" translate="notice.delete" ng-show="item.category==\'bbs\' || !item.id"></div>
                   <div class="btn cancel" ng-click="hideMe($event);onCancel({notice:item,$event:$event})" translate="notice.cancel-task" ng-show="item.id && item.category=='task'"></div>
                   <div class="btn copy" ng-click="hideMe($event);onCopy({notice:item,$event:$event})" translate="notice.copy-task" ng-show="item.id && item.category=='task'"></div>
                   </div>`,
        restrict: "E",
        replace:true,
        scope:{
            onEdit:"&",
            onDelete:"&",
            onCancel:"&",
            onCopy:"&"
        },
        link:function($scope,element){
            var offContextMenu = $scope.$on("onContextMenu",function(e,uiEvent){
                if($(uiEvent.target).closest(".noticeItem").length > 0){
                    var parent = $(uiEvent.target).closest(".noticeItem");
                    utils.applyScope($scope,function(){
                        $scope.item = parent.scope().item;
                        if($scope.item.category == 'task' && $scope.item.is_close){
                            element.addClass("hide");
                            return;
                        }

                        utils.getPosition(element,uiEvent);
                        element.removeClass("hide");
                    });
                }else{
                    element.addClass("hide");
                }
            });

            var offDocumentClick = $scope.$on("onDocumentClick",function(e,uiEvent){
                element.addClass("hide");
            });

            $scope.hideMe = function(e){
                e.stopPropagation();
                element.addClass("hide");
                element.removeAttr("style");
            };

            $scope.$on("$destroy",function(){
                offContextMenu();
                offDocumentClick();
            });
        }
    };
}]);
